<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BookingTerm extends Model 
{

    protected $table = 'booking_terms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('property_id', 'name', 'name_ar');

    public function property()
    {
        return $this->belongsTo('App\Models\Property');
    }

}